﻿using System;
using System.Collections.Generic;
using System.Reflection;
using HarmonyLib;
using Verse;
using RimWorld;

namespace yayoShooting
{

	[StaticConstructorOnStartup]
	public static class HarmonyPatches
	{

		static HarmonyPatches()
		{
			Harmony harmony = new Harmony("com.yayo.shooting");
			harmony.PatchAll(Assembly.GetExecutingAssembly());
		
		
		}


		[HarmonyPatch(typeof(Verb_LaunchProjectile), "WarmupComplete")]
		public class patch_WarmupComplete
		{
			[HarmonyPostfix]
			//[HarmonyPriority(0)]
			public static bool Prefix(Verb __instance)
			{
				if (!yayoShooting.using_Ammunition)
				{
					return true;
				}
				if (__instance.verbProps is VerbProperties_Custom2 && __instance.EquipmentSource != null && __instance.EquipmentSource.def.IsRangedWeapon)
				{
					try
					{
						((Action)(() =>
						{
							VerbProperties_Custom2 prop = __instance.verbProps as VerbProperties_Custom2;
							for (int i = 0; i < prop.ammoUse - 1; i++)
							{

								Ammunition.Utility.Utility.Fire(__instance.EquipmentSource, __instance.CasterPawn);
							}
							//return Ammunition.Utility.Utility.Fire(__instance.EquipmentSource, __instance.CasterPawn);
						}))();
					}
					catch (TypeLoadException) { }

					
				}
				return true;

			}
		}





		



	}


}
